<?php
class excel{ 
    /** 
     *头的excel文件（前缀的行） 
     * 
     *从excel复制的xml规格。 
     * 
     * @访问私有 
     * @无功串 
     */ 
    var $header = "<?xml version="1.0" encoding="utf-8"?> 
<workbook xmlns="urn:schemas-microsoft-com:office:spreadsheet" 
 xmlns:x="urn:schemas-microsoft-com:office:excel" 
 xmlns:ss="urn:schemas-microsoft-com:office:spreadsheet" 
 xmlns:html="http://www.w3.org/tr/rec-html40">"; 
    /** 
     *页脚的excel文件（附加到行） 
     * 
     *从excel复制的xml规格。 
     * 
     * @访问私有 
     * @无功串 
     */ 
    var $footer = "</workbook>"; 
    /** 
     * document lines (rows in an array) 
     *  
     * @access private 
     * @var array 
     */ 
    var $lines = array (); 
    /** 
     工作表名称 
     * 
     *包含一个单一的工作表名称 
     * 
     * @访问私有 
     * @无功串 
     */ 
    var $worksheet_title = "table1"; 
    /** 
  添加一个单行的文档字符串$ 
     * 
     * @访问私有 
     * @帕拉姆库马拉阵列一维阵列 
     * @待办事项行创造应做减本-> addarray 
     */ 
    function addrow ($array) { 
        // initialize all cells for this row 
        $cells = ""; 
         
        // foreach key -> write value into cells 
        foreach ($array as $k => $v): 
    
         // 加个字符串与数字的判断 避免生成的 excel 出现数字以字符串存储的警告 
         if(is_numeric($v)) { 
          // 防止首字母为 0 时生成 excel 后 0 丢失 
          if(substr($v, 0, 1) == 0) { 
           $cells .= "<cell><data ss:type="string">" . $v . "</data></cell> "; 
          } else { 
           $cells .= "<cell><data ss:type="number">" . $v . "</data></cell> "; 
          } 
         } else { 
             $cells .= "<cell><data ss:type="string">" . $v . "</data></cell> "; 
         } 
        endforeach; 
        // transform $cells content into one row 
        $this->lines[] = "<row> " . $cells . "</row> "; 
    } 
    /** 
    *添加一个数组到文档 
     * 
     *这应该是唯一的方法需要生成一个excel 
     *文件。 
     * 
     * @访问公开 
     * @帕拉姆库马拉数组二维数组 
     * @待办事项可以转移到__construct（）稍后 
     */ 
    function addarray ($array) { 
        // run through the array and add them into rows 
        foreach ($array as $k => $v): 
            $this->addrow ($v); 
        endforeach; 
    } 
    /** 
    设置工作表名称 
     * 
     *检查的字符串不允许字符（： /?*), 
     *削减它的最大31个字符，并设置标题。该死 
     *为何未允许字符无处可寻？视窗 
     *帮助没有帮助... 
     * 
     * @访问公开 
     * @帕拉姆库马拉字符串$标题设计标题 
     */ 
    function setworksheettitle ($title) { 
        // strip out special chars first 
        $title = preg_replace ("/[\|:|/|?|*|[|]]/", "", $title); 
        // now cut it to the allowed length 
        $title = substr ($title, 0, 31); 
        // set title 
        $this->worksheet_title = $title; 
    } 
   /** 
     *生成excel文件 
     * 
     *最后生成的excel文件，并使用header（）函数 
     *提供给浏览器。 
     * 
     * @访问公开 
     * @帕拉姆库马拉字符串$文件名名称的excel文件来生成（... xls）中 
     */ 
    function generatexml ($filename) { 
        // deliver header (as recommended in php manual) 
        header("content-type: application/vnd.ms-excel; charset=utf-8"); 
        header("content-disposition: inline; filename="" . $filename . ".xls""); 
        // print out document to the browser 
        // need to use strips教程lashes for the damn ">" 
        echo stripslashes ($this->header); 
        echo " <worksheet ss:name="" . $this->worksheet_title . ""> <table> ";//开源代码phpfensi.com 
        echo "<column ss:index="1" ss:autofitwidth="0" ss:width="110"/> "; 
        echo implode (" ", $this->lines); 
        echo "</table> </worksheet> "; 
        echo $this->footer; 
    } 
} 
cakephp中使用方法

注意:cakephp 配置文件 define('debug', 0);

vendor ('excel'); 
$doc = array ( 
     0 => array ('中国', '中国人', '中国人民', '123456'); 
); 
$xls = new excel; 
$xls->addarray ( $doc ); 
$xls->generatexml ("mytest"); 
非框架使用方法,实例代码如下:

require_once('excel.php'); 
$doc = array ( 
     0 => array ('中国', '中国人', '中国人民', '123456'); 
); 
$xls = new excel; 
$xls->addarray ( $doc ); 
$xls->generatexml ("mytest");
?>